/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic_view.ViewDistHandler;

import com.dynamic_view.DynView;
import com.dynamic_view.ViewDistHandler.IDynamicViewDistanceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Mth;
import net.minecraftforge.server.ServerLifecycleHooks;

public class ServerDynamicViewDistanceManager
implements IDynamicViewDistanceManager {
    private static final int UPDATE_LEEWAY = 3;
    private static ServerDynamicViewDistanceManager instance;
    public static int minChunkViewDist;
    public static int maxChunkViewDist;
    public static int minChunkUpdateDist;
    public static int maxChunkUpdateDist;
    public static double meanTickToStayBelow;
    private boolean reduceViewDistance = true;
    private boolean increaseViewDistance = true;
    private int currentChunkViewDist = 0;
    private int currentChunkUpdateDist = 0;

    private ServerDynamicViewDistanceManager() {
    }

    public static IDynamicViewDistanceManager getInstance() {
        if (instance == null) {
            instance = new ServerDynamicViewDistanceManager();
        }
        return instance;
    }

    @Override
    public void initViewDist() {
        this.currentChunkViewDist = (minChunkViewDist + maxChunkViewDist) / 2;
        this.currentChunkUpdateDist = (minChunkUpdateDist + maxChunkUpdateDist) / 2;
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11217_(minChunkViewDist);
        if (((Boolean)DynView.getConfig().getCommonConfig().adjustSimulationDistance.get()).booleanValue()) {
            ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
        }
    }

    @Override
    public void updateViewDistForMeanTick(int meanTickTime) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server.m_6846_().m_11314_().isEmpty()) {
            return;
        }
        if ((double)(meanTickTime - 3) > meanTickToStayBelow) {
            this.increaseViewDistance = true;
            if (this.reduceViewDistance && this.currentChunkViewDist > minChunkViewDist) {
                this.reduceViewDistance = (Boolean)DynView.getConfig().getCommonConfig().adjustSimulationDistance.get() == false;
                --this.currentChunkViewDist;
                if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing chunk view distance to: " + this.currentChunkViewDist);
                }
                server.m_6846_().m_11217_(this.currentChunkViewDist);
                return;
            }
            if (!this.reduceViewDistance && this.currentChunkUpdateDist > minChunkUpdateDist) {
                this.reduceViewDistance = true;
                --this.currentChunkUpdateDist;
                if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms decreasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                server.m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
            }
            if (!((Boolean)DynView.getConfig().getCommonConfig().adjustSimulationDistance.get()).booleanValue()) {
                this.reduceViewDistance = true;
            }
        }
        if ((double)(meanTickTime + 3) < meanTickToStayBelow) {
            this.reduceViewDistance = false;
            if (this.increaseViewDistance && this.currentChunkViewDist < maxChunkViewDist) {
                this.increaseViewDistance = (Boolean)DynView.getConfig().getCommonConfig().adjustSimulationDistance.get() == false;
                ++this.currentChunkViewDist;
                if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing chunk view distance to: " + this.currentChunkViewDist);
                }
                server.m_6846_().m_11217_(this.currentChunkViewDist);
                return;
            }
            if (!this.increaseViewDistance && this.currentChunkUpdateDist < maxChunkUpdateDist) {
                this.increaseViewDistance = true;
                ++this.currentChunkUpdateDist;
                if (((Boolean)DynView.getConfig().getCommonConfig().logMessages.get()).booleanValue()) {
                    DynView.LOGGER.info("Mean tick: " + meanTickTime + "ms increasing simulation distance to: " + this.currentChunkUpdateDist);
                }
                server.m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
            }
            if (!((Boolean)DynView.getConfig().getCommonConfig().adjustSimulationDistance.get()).booleanValue()) {
                this.increaseViewDistance = true;
            }
        }
    }

    @Override
    public void setCurrentChunkViewDist(int currentChunkViewDist) {
        this.currentChunkViewDist = Mth.m_14045_((int)currentChunkViewDist, (int)0, (int)200);
        ServerLifecycleHooks.getCurrentServer().m_6846_().m_11217_(this.currentChunkViewDist);
    }

    @Override
    public void setCurrentChunkUpdateDist(int currentChunkUpdateDist) {
        this.currentChunkUpdateDist = Mth.m_14045_((int)currentChunkUpdateDist, (int)0, (int)200);
        ServerLifecycleHooks.getCurrentServer().m_129785_().forEach(level -> level.m_7726_().m_184026_(this.currentChunkUpdateDist));
    }
}

